// Pom1 Apple 1 Emulator
// Copyright (C) 2000 Verhille Arnaud
// Copyright (C) 2006 John D. Corrado
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#include <SDL.h>
#include "m6502.h"
#include "memory.h"
#include "keyboard.h"
#include "screen.h"
#include "configuration.h"
#include "pom1_icon.c"

int main(int argc, char *argv[])
{
	SDL_Surface *surface;

	if (SDL_Init(SDL_INIT_VIDEO) < 0)
	{
		fprintf(stderr, "Could not initialize SDL\n");
		return 0;
	}

	atexit(SDL_Quit);

	loadConfiguration();

	atexit(saveConfiguration);

	if (!SDL_SetVideoMode(280 * getPixelSize(), 192 * getPixelSize(), 8, SDL_HWSURFACE | SDL_DOUBLEBUF | (getFullScreen() ? SDL_FULLSCREEN : 0)))
	{
		fprintf(stderr, "Could not set video mode to %dx%dx8\n", 280 * getPixelSize(), 192 * getPixelSize());
		return 0;
	}

	SDL_WM_SetCaption("Pom1 Apple 1 Emulator", NULL);

	surface = SDL_CreateRGBSurfaceFrom(pom1_data, pom1_w, pom1_h, 24, pom1_w * 3, 0xff, 0xff << 8, 0xff << 16, 0);
	
	if (surface)
	{
		SDL_WM_SetIcon(surface, NULL);
		SDL_FreeSurface(surface);
	}

	SDL_EnableKeyRepeat(SDL_DEFAULT_REPEAT_DELAY, SDL_DEFAULT_REPEAT_INTERVAL);

	SDL_EnableUNICODE(1);

	SDL_ShowCursor(!getFullScreen());

	if (!loadCharMap())
	{
		fprintf(stderr, "Could not load character map\n");
		return 0;
	}

	if (!loadMonitor())
	{
		fprintf(stderr, "Could not load monitor\n");
		return 0;
	}

	resetScreen();
	resetMemory();
	setSpeed(1000, 50);
	resetM6502();
	startM6502();

	atexit(stopM6502);

	while (handleInput());

	return 0;
}
